/*
 * Decompiled with CFR 0.152.
 */
package com.appreciate.mastertenant.onboarding.entity;

import com.appreciate.application.utils.AuditModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.UUID;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="master_tenant")
public class MasterTenant
extends AuditModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UUID")
    @GenericGenerator(name="UUID", strategy="org.hibernate.id.UUIDGenerator")
    @Column(name="id", updatable=false, nullable=false, unique=true)
    private UUID id;
    @Column(name="db_name", nullable=false, unique=true, length=100)
    private String dbName;
    @Column(name="status", nullable=false, length=50)
    private String status;
    @Column(name="realm_name", nullable=false, unique=true, length=100)
    private String realmName;
    @Column(name="tenant_id", nullable=false, unique=true, length=100)
    private String tenantId;
    @Column(name="tenant_reference_id", unique=true, length=20)
    private String tenantReferenceId;
    @Column(name="public_key")
    private String publicKey;
    @Column(name="private_key")
    private String privateKey;
    @Column(name="is_encrypt_decrypt_enable")
    @ColumnDefault(value="FALSE")
    private boolean isEncryptDecryptEnable;
    @Column(name="partner_sqs_link")
    private String partnerSQSLink;

    public UUID getId() {
        return this.id;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantReferenceId() {
        return this.tenantReferenceId;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isEncryptDecryptEnable() {
        return this.isEncryptDecryptEnable;
    }

    public String getPartnerSQSLink() {
        return this.partnerSQSLink;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantReferenceId(String tenantReferenceId) {
        this.tenantReferenceId = tenantReferenceId;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setEncryptDecryptEnable(boolean isEncryptDecryptEnable) {
        this.isEncryptDecryptEnable = isEncryptDecryptEnable;
    }

    public void setPartnerSQSLink(String partnerSQSLink) {
        this.partnerSQSLink = partnerSQSLink;
    }

    public String toString() {
        return "MasterTenant(id=" + this.getId() + ", dbName=" + this.getDbName() + ", status=" + this.getStatus() + ", realmName=" + this.getRealmName() + ", tenantId=" + this.getTenantId() + ", tenantReferenceId=" + this.getTenantReferenceId() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", isEncryptDecryptEnable=" + this.isEncryptDecryptEnable() + ", partnerSQSLink=" + this.getPartnerSQSLink() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterTenant)) {
            return false;
        }
        MasterTenant other = (MasterTenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEncryptDecryptEnable() != other.isEncryptDecryptEnable()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$realmName = this.getRealmName();
        String other$realmName = other.getRealmName();
        if (this$realmName == null ? other$realmName != null : !this$realmName.equals(other$realmName)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$tenantReferenceId = this.getTenantReferenceId();
        String other$tenantReferenceId = other.getTenantReferenceId();
        if (this$tenantReferenceId == null ? other$tenantReferenceId != null : !this$tenantReferenceId.equals(other$tenantReferenceId)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$partnerSQSLink = this.getPartnerSQSLink();
        String other$partnerSQSLink = other.getPartnerSQSLink();
        return !(this$partnerSQSLink == null ? other$partnerSQSLink != null : !this$partnerSQSLink.equals(other$partnerSQSLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MasterTenant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEncryptDecryptEnable() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $realmName = this.getRealmName();
        result = result * 59 + ($realmName == null ? 43 : $realmName.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $tenantReferenceId = this.getTenantReferenceId();
        result = result * 59 + ($tenantReferenceId == null ? 43 : $tenantReferenceId.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $partnerSQSLink = this.getPartnerSQSLink();
        result = result * 59 + ($partnerSQSLink == null ? 43 : $partnerSQSLink.hashCode());
        return result;
    }

    public MasterTenant(UUID id, String dbName, String status, String realmName, String tenantId, String tenantReferenceId, String publicKey, String privateKey, boolean isEncryptDecryptEnable, String partnerSQSLink) {
        this.id = id;
        this.dbName = dbName;
        this.status = status;
        this.realmName = realmName;
        this.tenantId = tenantId;
        this.tenantReferenceId = tenantReferenceId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.isEncryptDecryptEnable = isEncryptDecryptEnable;
        this.partnerSQSLink = partnerSQSLink;
    }

    public MasterTenant() {
    }
}

