/*
 * Decompiled with CFR 0.152.
 */
package com.appreciate.application.utils;

import com.appreciate.application.exception.ResponseInfo;
import com.appreciate.application.exception.TenantApiSuccess;
import java.util.Collections;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public final class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Pageable getPageable(int page, int size, String sort, String order) {
        PageRequest sorted = sort != null && !sort.isEmpty() && order != null && !order.isEmpty() && order.equalsIgnoreCase("DESCENDING") ? PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{sort}).descending()) : (sort != null && !sort.isEmpty() ? PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{sort})) : PageRequest.of((int)page, (int)size));
        return sorted;
    }

    public static Pageable getPageableWithoutSorting(int page, int size) {
        PageRequest sorted = PageRequest.of((int)page, (int)size);
        return sorted;
    }

    public static ResponseEntity<Object> buildResponseEntity(TenantApiSuccess tenantApiSuccess, HttpStatus status) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Custom-Header", "Custom-Value");
        headers.add("Another-Header", "Another-Value");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).headers(headers)).body((Object)tenantApiSuccess);
    }

    public static TenantApiSuccess handleApiSuccessResponse(ResponseInfo responseInfo, Object data) {
        return TenantApiSuccess.builder().status(true).type("Success").message(responseInfo.getMessage()).errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode(responseInfo.getErrorCode()).errorMessage(responseInfo.getErrorMessage()).build()).data(data).build();
    }

    public static TenantApiSuccess handleApiFailueResponse(ResponseInfo responseInfo) {
        return TenantApiSuccess.builder().status(false).type("Failure").message(responseInfo.getMessage()).errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode(responseInfo.getErrorCode()).errorMessage(responseInfo.getErrorMessage()).build()).data(Collections.emptyMap()).build();
    }

    public static TenantApiSuccess handleApiFailueResponse(String errorCode, String errorMessage, String message) {
        return TenantApiSuccess.builder().status(false).type("Failure").message(message).errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode(errorCode).errorMessage(errorMessage).build()).data(Collections.emptyMap()).build();
    }
}

