/*
 * Decompiled with CFR 0.152.
 */
package com.appreciate.application.resolver;

import com.appreciate.application.resolver.TenantContext;
import com.appreciate.application.resolver.TenantHttpProperties;
import com.appreciate.application.resolver.TenantResolver;
import io.micrometer.common.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class CurrentTenantIdentifierResolverImpl
implements CurrentTenantIdentifierResolver,
TenantResolver<HttpServletRequest> {
    private static final String DEFAULT_TENANT_ID = "client_tenant_1";
    @Autowired
    private TenantHttpProperties tenantHttpProperties;

    @Override
    public String resolveTenantId(@NonNull HttpServletRequest request) {
        return request.getHeader(this.tenantHttpProperties.getHeaderName());
    }

    public String resolveCurrentTenantIdentifier() {
        String tenant = TenantContext.getTenantId();
        return StringUtils.isNotBlank((String)tenant) ? tenant : DEFAULT_TENANT_ID;
    }

    public boolean validateExistingCurrentSessions() {
        return true;
    }
}

