/*
 * Decompiled with CFR 0.152.
 */
package com.appreciate.application.exception;

import com.appreciate.application.exception.ApiError;
import com.appreciate.application.exception.AppreciateB2BException;
import com.appreciate.application.exception.AppreciateException;
import com.appreciate.application.exception.TenantApiSuccess;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Order(value=-2147483648)
@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger EXCEPTION_LOGGER = LogManager.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AppreciateException.class})
    public ResponseEntity<TenantApiSuccess> appreciateExceptionHandler(AppreciateException ex) {
        TenantApiSuccess apiResponse = TenantApiSuccess.builder().status(false).type("Failure").message(ex.getMessage()).errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode(ex.getErrorCode()).errorMessage(ex.getErrorMessage()).build()).data(Collections.emptyMap()).build();
        return new ResponseEntity((Object)apiResponse, ex.getHttpStatus());
    }

    @ExceptionHandler(value={AppreciateB2BException.class})
    protected ResponseEntity<Object> appreciateB2BExceptionHandler(AppreciateB2BException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException ex, WebRequest request) {
        if (ex.getCause() instanceof ConstraintViolationException) {
            return this.buildResponseEntity(new ApiError(HttpStatus.CONFLICT, "Database error", ex.getCause()));
        }
        return this.buildResponseEntity(new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException ex, WebRequest request) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(String.format("The parameter '%s' of value '%s' could not be converted to type '%s'", ex.getName(), ex.getValue(), ex.getRequiredType().getSimpleName()));
        apiError.setDebugMessage(ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<Object> handleConstraintViolation(MethodArgumentNotValidException ex) {
        List errors = ex.getBindingResult().getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        TenantApiSuccess apiResponse = TenantApiSuccess.builder().status(false).type("Failure").message("validation failed").errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode("E12998").errorMessage(ex.getLocalizedMessage()).build()).data(Collections.emptyMap()).build();
        return new ResponseEntity((Object)apiResponse, (HttpStatusCode)HttpStatus.OK);
    }

    private Map<String, List<String>> getErrorsMap(List<String> errors) {
        HashMap<String, List<String>> errorResponse = new HashMap<String, List<String>>();
        errorResponse.put("errors", errors);
        return errorResponse;
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    protected ResponseEntity<Object> handleBadCredentialException(BadCredentialsException ex) {
        TenantApiSuccess apiResponse = TenantApiSuccess.builder().status(false).type("Failure").message("Invalid X-AccessToken").errorStatus(TenantApiSuccess.ErrorStatusDTO.builder().errorCode("E12998").errorMessage(ex.getLocalizedMessage()).build()).data(Collections.emptyMap()).build();
        return new ResponseEntity((Object)apiResponse, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    private ResponseEntity<Object> buildResponseEntity(ApiError apiError) {
        EXCEPTION_LOGGER.error("Error : " + apiError.toString());
        return new ResponseEntity((Object)apiError, (HttpStatusCode)apiError.getError());
    }
}

