/*
 * Decompiled with CFR 0.152.
 */
package com.appreciate.application.exception;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

class ApiError {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy hh:mm:ss")
    private LocalDateTime timestamp = LocalDateTime.now();
    private int status;
    private HttpStatus error;
    private String message;
    private String debugMessage;
    private List<ApiSubError> subErrors;

    private ApiError() {
    }

    ApiError(HttpStatus error) {
        this();
        this.error = error;
        this.status = error.value();
    }

    ApiError(HttpStatus error, Throwable ex) {
        this();
        this.error = error;
        this.status = error.value();
        this.message = "Unexpected error";
        this.debugMessage = ex.getLocalizedMessage();
    }

    ApiError(HttpStatus error, String message, Throwable ex) {
        this();
        this.error = error;
        this.status = error.value();
        this.message = message;
        this.debugMessage = ex.getLocalizedMessage();
    }

    private void addSubError(ApiSubError subError) {
        if (this.subErrors == null) {
            this.subErrors = new ArrayList<ApiSubError>();
        }
        this.subErrors.add(subError);
    }

    private void addValidationError(String object, String field, Object rejectedValue, String message) {
        this.addSubError(new ApiValidationError(object, field, rejectedValue, message));
    }

    private void addValidationError(String object, String message) {
        this.addSubError(new ApiValidationError(object, message));
    }

    private void addValidationError(FieldError fieldError) {
        this.addValidationError(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage());
    }

    void addValidationErrors(List<FieldError> fieldErrors) {
        fieldErrors.forEach(this::addValidationError);
    }

    private void addValidationError(ObjectError objectError) {
        this.addValidationError(objectError.getObjectName(), objectError.getDefaultMessage());
    }

    void addValidationError(List<ObjectError> globalErrors) {
        globalErrors.forEach(this::addValidationError);
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public int getStatus() {
        return this.status;
    }

    public HttpStatus getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public List<ApiSubError> getSubErrors() {
        return this.subErrors;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy hh:mm:ss")
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setError(HttpStatus error) {
        this.error = error;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDebugMessage(String debugMessage) {
        this.debugMessage = debugMessage;
    }

    public void setSubErrors(List<ApiSubError> subErrors) {
        this.subErrors = subErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiError)) {
            return false;
        }
        ApiError other = (ApiError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        HttpStatus this$error = this.getError();
        HttpStatus other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$debugMessage = this.getDebugMessage();
        String other$debugMessage = other.getDebugMessage();
        if (this$debugMessage == null ? other$debugMessage != null : !this$debugMessage.equals(other$debugMessage)) {
            return false;
        }
        List<ApiSubError> this$subErrors = this.getSubErrors();
        List<ApiSubError> other$subErrors = other.getSubErrors();
        return !(this$subErrors == null ? other$subErrors != null : !((Object)this$subErrors).equals(other$subErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        HttpStatus $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $debugMessage = this.getDebugMessage();
        result = result * 59 + ($debugMessage == null ? 43 : $debugMessage.hashCode());
        List<ApiSubError> $subErrors = this.getSubErrors();
        result = result * 59 + ($subErrors == null ? 43 : ((Object)$subErrors).hashCode());
        return result;
    }

    public String toString() {
        return "ApiError(timestamp=" + this.getTimestamp() + ", status=" + this.getStatus() + ", error=" + this.getError() + ", message=" + this.getMessage() + ", debugMessage=" + this.getDebugMessage() + ", subErrors=" + this.getSubErrors() + ")";
    }

    class ApiValidationError
    extends ApiSubError {
        private String object;
        private String field;
        private Object rejectedValue;
        private String message;

        ApiValidationError(String object, String message) {
            this.object = object;
            this.message = message;
        }

        public String getObject() {
            return this.object;
        }

        public String getField() {
            return this.field;
        }

        public Object getRejectedValue() {
            return this.rejectedValue;
        }

        public String getMessage() {
            return this.message;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setRejectedValue(Object rejectedValue) {
            this.rejectedValue = rejectedValue;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "ApiError.ApiValidationError(object=" + this.getObject() + ", field=" + this.getField() + ", rejectedValue=" + this.getRejectedValue() + ", message=" + this.getMessage() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiValidationError)) {
                return false;
            }
            ApiValidationError other = (ApiValidationError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            Object this$rejectedValue = this.getRejectedValue();
            Object other$rejectedValue = other.getRejectedValue();
            if (this$rejectedValue == null ? other$rejectedValue != null : !this$rejectedValue.equals(other$rejectedValue)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiValidationError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            Object $rejectedValue = this.getRejectedValue();
            result = result * 59 + ($rejectedValue == null ? 43 : $rejectedValue.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public ApiValidationError(String object, String field, Object rejectedValue, String message) {
            this.object = object;
            this.field = field;
            this.rejectedValue = rejectedValue;
            this.message = message;
        }
    }

    abstract class ApiSubError {
        ApiSubError() {
        }
    }
}

